package com.app.yoursingleradio.fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;

import com.app.yoursingleradio.R;
import com.app.yoursingleradio.activities.MainActivity;

@SuppressWarnings("deprecation")
public class FragmentRadio extends Fragment {

    private MainActivity mainActivity;
    private Toolbar toolbar;
    View view;

    public FragmentRadio() {
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        mainActivity = (MainActivity) context;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.fragment_radio, container, false);
        toolbar = view.findViewById(R.id.toolbar);
        setupToolbar();
        return view;

    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mainActivity.setupNavigationDrawer(toolbar);
    }

    private void setupToolbar() {
        toolbar.setTitle("");
        mainActivity.setSupportActionBar(toolbar);
    }

}